#!/c/Perl/bin//perl -w
#
# $Id: namazu-10.pl.in,v 1.1.4.3 2006/01/10 19:37:18 opengl2772 Exp $
# Copyright (C) 2004-2006 Tadamasa Teranishi
#               2004-2006 Namazu Project All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either versions 2, or (at your option)
#  any later version.
#
#  This program is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#  02111-1307, USA
#
#  This file must be encoded in EUC-JP encoding
#
#

#
# Test for namazu. with MaxHit, MaxMatch.
#

use strict;
require Cwd;
require 'pltests.pl';

my $cwd = Cwd::cwd();
my $LOG = "$cwd/test-log";
my $INDEX = "$cwd/idx8";
my $NAMAZU = pltests::binpath('namazu');


my $MSG = "Present index is old type. it's unsupported.";

my @cmd;

delete $ENV{'LANG'};
$ENV{'LANGUAGE'} = 'C';
$ENV{'LC_ALL'} = 'C';
delete $ENV{'LC_MESSAGE'};
delete $ENV{'LC_CTYPE'};
delete $ENV{'NAMAZURC'};

pltests::putline($LOG, "  *** starting $0");

rename("$INDEX/NMZ.wi", "$INDEX/NMZ.wi.org");

@cmd = ("$NAMAZU", "namazu", "$INDEX");
pltests::putline($LOG, "  ", \@cmd);
my ($status, $result, $conts_err) = pltests::ezsyscmd(\@cmd);
if (-f "$INDEX/NMZ.wi") {
    unlink "$INDEX/NMZ.wi";
}
rename("$INDEX/NMZ.wi.org", "$INDEX/NMZ.wi");
unless (defined $result) {
    exit 1;
}
if ($result !~ /$MSG/s) {
    exit 1;
}

exit 0;
